# app.py

from flask import Flask, request, render_template, redirect, url_for, flash
import requests
import os

app = Flask(__name__)
app.secret_key = os.getenv('FLASK_API_KEY', 'chave-secreta')  # Pode usar valor direto se quiser

# Configurações do WordPress via variáveis de ambiente (painel cPanel)
WP_API_URL = os.getenv('WP_API_URL')
WP_USER = os.getenv('WP_USER')
WP_PASSWORD = os.getenv('WP_PASSWORD')

@app.route('/')
def index():
    return render_template('index.html')

@app.route('/criar_post', methods=['POST'])
def criar_post():
    titulo = request.form.get('titulo')
    conteudo = request.form.get('conteudo')
    categoria = request.form.get('categoria')

    if not titulo or not conteudo:
        flash('Título e conteúdo são obrigatórios!')
        return redirect(url_for('index'))

    dados = {
        'title': titulo,
        'content': conteudo,
        'status': 'publish',
        'categories': [int(categoria)] if categoria else [1]
    }

    resposta = requests.post(
        WP_API_URL,
        auth=(WP_USER, WP_PASSWORD),
        json=dados
    )

    if resposta.status_code == 201:
        flash('✅ Post criado com sucesso no WordPress!')
    else:
        flash(f'❌ Erro ao criar post: {resposta.status_code} - {resposta.text}')

    return redirect(url_for('index'))

# 👇 ESSENCIAL para funcionar no cPanel (ponto de entrada "application")
application = app